IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[PG_CRED_CD_BARRAS]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[PG_CRED_CD_BARRAS](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PG_CRED] [int] NOT NULL,
	[CD_BARRAS_BOLETA] [varchar](250) NOT NULL,
 CONSTRAINT [PK_PG_CRED_CD_BARRAS] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PG_CRED] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PG_CRED_CD_BARRAS] UNIQUE NONCLUSTERED 
(
	[CD_BARRAS_BOLETA] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[PG_CRED_CD_BARRAS]  WITH CHECK ADD  CONSTRAINT [FK_PG_CRED_CD_BARRAS_PG_CRED] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PG_CRED])
REFERENCES [dbo].[PG_CRED] ([CD_EMP], [CD_FILIAL], [CD_PG_CRED])

ALTER TABLE [dbo].[PG_CRED_CD_BARRAS] CHECK CONSTRAINT [FK_PG_CRED_CD_BARRAS_PG_CRED]
end

